#ifndef __CHtmlMenuItem__
#define __CHtmlMenuItem__

#include <Basics/CHtmlString.hpp>
#include "CMenuItem.hpp"

//	===========================================================================

using Exponent::Basics::CString;
using Exponent::Basics::CHtmlString;
using Exponent::GUI::Controls::CMenuItem;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CHtmlMenuItem CHtmlMenuItem.hpp
			 * @brief A representation of a menu item that can be lauched in a default browser
			 *
			 * @date 12/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 * @see CHtmlString
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CHtmlMenuItem.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CHtmlMenuItem : public CMenuItem
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================
				
				/**
				 * Construction
				 * @param link The html string to display
				 * @param displayText The text to display
				 * @param id The id of the menu item
				 */
				CHtmlMenuItem(const CHtmlString &link, const CString &displayText, const long id);

				/**
				 * Destruction
				 */
				virtual ~CHtmlMenuItem();

//	===========================================================================
				
				/**
				 * Lauch the link
				 */
				void lauchLinkInBrowser();

//	===========================================================================

			protected:

//	===========================================================================

				CHtmlString m_link;				/**< The linked site.. */
			};
		}
	}
}
#endif	// End of CHtmlMenuItem.hpp